/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.MinecoloniesMinecart;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.entity.pathfinding.IStuckHandler;
import com.minecolonies.api.entity.pathfinding.PathFindingStatus;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.entity.pathfinding.PathingStuckHandler;
import com.minecolonies.api.entity.pathfinding.TreePathResult;
import com.minecolonies.api.entity.pathfinding.WaterPathResult;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.entity.pathfinding.MovementHandler;
import com.minecolonies.coremod.entity.pathfinding.PathPointExtended;
import com.minecolonies.coremod.entity.pathfinding.Pathfinding;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobFindTree;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobFindWater;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobMoveAwayFromLocation;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobMoveToLocation;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobRandomPos;
import com.minecolonies.coremod.util.WorkerUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.LadderBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinecoloniesAdvancedPathNavigate
extends AbstractAdvancedPathNavigate {
    private static final double ON_PATH_SPEED_MULTIPLIER = 1.3;
    public static final double MIN_Y_DISTANCE = 0.001;
    public static final int MAX_SPEED_ALLOWED = 2;
    public static final double MIN_SPEED_ALLOWED = 0.1;
    @Nullable
    private PathResult<AbstractPathJob> pathResult;
    private long pathStartTime = 0L;
    private BlockPos spawnedPos = BlockPos.field_177992_a;
    private BlockPos desiredPos;
    private int desiredPosTimeout = 0;
    private IStuckHandler stuckHandler;
    private boolean isSneaking = true;
    private double swimSpeedFactor = 1.0;

    public MinecoloniesAdvancedPathNavigate(@NotNull MobEntity entity, World world) {
        super(entity, world);
        entity.field_70765_h = new MovementHandler(entity);
        this.field_179695_a = new WalkNodeProcessor();
        this.field_179695_a.func_186317_a(true);
        this.getPathingOptions().setEnterDoors(true);
        this.field_179695_a.func_186321_b(true);
        this.getPathingOptions().setCanOpenDoors(true);
        this.field_179695_a.func_186316_c(true);
        this.getPathingOptions().setCanSwim(true);
        this.stuckHandler = PathingStuckHandler.createStuckHandler().withTakeDamageOnStuck(0.2f).withTeleportSteps(6).withTeleportOnFullStuck();
    }

    @Override
    public BlockPos getDestination() {
        return this.destination;
    }

    @Override
    @Nullable
    public PathResult moveAwayFromXYZ(BlockPos avoid, double range, double speedFactor, boolean safeDestination) {
        @NotNull BlockPos start = AbstractPathJob.prepareStart((LivingEntity)this.ourEntity);
        return this.setPathJob(new PathJobMoveAwayFromLocation(CompatibilityUtils.getWorldFromEntity((Entity)this.ourEntity), start, avoid, (int)range, (int)this.ourEntity.func_110148_a(Attributes.field_233819_b_).func_111126_e(), (LivingEntity)this.ourEntity), null, speedFactor, safeDestination);
    }

    @Override
    @Nullable
    public PathResult moveToRandomPos(double range, double speedFactor) {
        if (this.pathResult != null && this.pathResult.getJob() instanceof PathJobRandomPos) {
            return this.pathResult;
        }
        this.desiredPos = BlockPos.field_177992_a;
        int theRange = (int)((double)this.field_75515_a.func_70681_au().nextInt((int)range) + range / 2.0);
        @NotNull BlockPos start = AbstractPathJob.prepareStart((LivingEntity)this.ourEntity);
        return this.setPathJob(new PathJobRandomPos(CompatibilityUtils.getWorldFromEntity((Entity)this.ourEntity), start, theRange, (int)this.ourEntity.func_110148_a(Attributes.field_233819_b_).func_111126_e(), (LivingEntity)this.ourEntity), null, speedFactor, true);
    }

    @Override
    @Nullable
    public PathResult moveToRandomPosAroundX(int range, double speedFactor, BlockPos pos) {
        if (this.pathResult != null && this.pathResult.getJob() instanceof PathJobRandomPos && ((PathJobRandomPos)this.pathResult.getJob()).posAndRangeMatch(range, pos)) {
            return this.pathResult;
        }
        this.desiredPos = BlockPos.field_177992_a;
        return this.setPathJob(new PathJobRandomPos(CompatibilityUtils.getWorldFromEntity((Entity)this.ourEntity), AbstractPathJob.prepareStart((LivingEntity)this.ourEntity), 3, (int)this.ourEntity.func_110148_a(Attributes.field_233819_b_).func_111126_e(), range, (LivingEntity)this.ourEntity, pos), pos, speedFactor, true);
    }

    @Override
    public PathResult moveToRandomPos(int range, double speedFactor, net.minecraft.util.Tuple<BlockPos, BlockPos> corners, AbstractAdvancedPathNavigate.RestrictionType restrictionType) {
        if (this.pathResult != null && this.pathResult.getJob() instanceof PathJobRandomPos) {
            return this.pathResult;
        }
        this.desiredPos = BlockPos.field_177992_a;
        int theRange = this.field_75515_a.func_70681_au().nextInt(range) + range / 2;
        @NotNull BlockPos start = AbstractPathJob.prepareStart((LivingEntity)this.ourEntity);
        return this.setPathJob(new PathJobRandomPos(CompatibilityUtils.getWorldFromEntity((Entity)this.ourEntity), start, theRange, (int)this.ourEntity.func_110148_a(Attributes.field_233819_b_).func_111126_e(), (LivingEntity)this.ourEntity, (BlockPos)corners.func_76341_a(), (BlockPos)corners.func_76340_b(), restrictionType), null, speedFactor, true);
    }

    @Nullable
    public PathResult setPathJob(@NotNull AbstractPathJob job, BlockPos dest, double speedFactor, boolean safeDestination) {
        this.func_75499_g();
        this.destination = dest;
        this.originalDestination = dest;
        if (safeDestination) {
            this.desiredPos = dest;
            if (dest != null) {
                this.desiredPosTimeout = 1000;
            }
        }
        this.walkSpeedFactor = speedFactor;
        if (speedFactor > 2.0 || speedFactor < 0.1) {
            Log.getLogger().error("Tried to set a bad speed:" + speedFactor + " for entity:" + this.ourEntity, (Throwable)new Exception());
            return null;
        }
        job.setPathingOptions(this.getPathingOptions());
        this.pathResult = job.getResult();
        this.pathResult.startJob(Pathfinding.getExecutor());
        return this.pathResult;
    }

    public boolean func_75500_f() {
        return (this.pathResult == null || this.pathResult.isDone() && this.pathResult.getStatus() != PathFindingStatus.CALCULATION_COMPLETE) && super.func_75500_f();
    }

    public void func_75501_e() {
        int oldIndex;
        if (this.desiredPosTimeout > 0 && --this.desiredPosTimeout <= 0) {
            this.desiredPos = null;
        }
        if (this.pathResult != null) {
            if (!this.pathResult.isDone()) {
                return;
            }
            if (this.pathResult.getStatus() == PathFindingStatus.CALCULATION_COMPLETE) {
                this.processCompletedCalculationResult();
            }
        }
        int n = oldIndex = this.func_75500_f() ? 0 : this.func_75505_d().func_75873_e();
        if (this.isSneaking) {
            this.isSneaking = false;
            this.field_75515_a.func_226284_e_(false);
        }
        this.ourEntity.func_70657_f(0.0f);
        if (this.handleLadders(oldIndex)) {
            this.func_75508_h();
            this.stuckHandler.checkStuck(this);
            return;
        }
        if (this.handleRails()) {
            this.stuckHandler.checkStuck(this);
            return;
        }
        ++this.field_75510_g;
        if (this.field_188562_p) {
            this.func_188554_j();
        }
        if (!this.func_75500_f()) {
            Vector3d vector3d2;
            BlockPos blockpos;
            if (this.func_75485_k()) {
                this.func_75508_h();
            } else if (this.field_75514_c != null && !this.field_75514_c.func_75879_b()) {
                Vector3d vector3d = this.func_75502_i();
                Vector3d vector3d1 = this.field_75514_c.func_75878_a((Entity)this.field_75515_a);
                if (vector3d.field_72448_b > vector3d1.field_72448_b && !this.field_75515_a.func_233570_aj_() && MathHelper.func_76128_c((double)vector3d.field_72450_a) == MathHelper.func_76128_c((double)vector3d1.field_72450_a) && MathHelper.func_76128_c((double)vector3d.field_72449_c) == MathHelper.func_76128_c((double)vector3d1.field_72449_c)) {
                    this.field_75514_c.func_75875_a();
                }
            }
            DebugPacketSender.func_218803_a((World)this.field_75513_b, (MobEntity)this.field_75515_a, (Path)this.field_75514_c, (float)this.field_188561_o);
            if (!this.func_75500_f() && WorldUtil.isEntityBlockLoaded((IWorld)this.field_75513_b, blockpos = new BlockPos(vector3d2 = this.field_75514_c.func_75878_a((Entity)this.field_75515_a)))) {
                this.field_75515_a.func_70605_aq().func_75642_a(vector3d2.field_72450_a, this.field_75513_b.func_180495_p(blockpos.func_177977_b()).func_196958_f() ? vector3d2.field_72448_b : MinecoloniesAdvancedPathNavigate.getSmartGroundY((IBlockReader)this.field_75513_b, blockpos), vector3d2.field_72449_c, this.field_75511_d);
            }
        }
        if (this.pathResult != null && this.func_75500_f()) {
            this.pathResult.setStatus(PathFindingStatus.COMPLETE);
            this.pathResult = null;
        }
        this.stuckHandler.checkStuck(this);
    }

    public static double getSmartGroundY(IBlockReader world, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        VoxelShape voxelshape = world.func_180495_p(blockpos).func_196952_d(world, blockpos);
        if (voxelshape.func_197766_b() || voxelshape.func_197758_c(Direction.Axis.Y) < 1.0) {
            return pos.func_177956_o();
        }
        return (double)blockpos.func_177956_o() + voxelshape.func_197758_c(Direction.Axis.Y);
    }

    @Override
    @Nullable
    public PathResult moveToXYZ(double x, double y, double z, double speedFactor) {
        int newX = MathHelper.func_76128_c((double)x);
        int newY = (int)y;
        int newZ = MathHelper.func_76128_c((double)z);
        if (this.pathResult != null && this.pathResult.getJob() instanceof PathJobMoveToLocation && (this.pathResult.isComputing() || this.destination != null && BlockPosUtil.isEqual(this.destination, newX, newY, newZ) || this.originalDestination != null && BlockPosUtil.isEqual(this.originalDestination, newX, newY, newZ))) {
            return this.pathResult;
        }
        @NotNull BlockPos start = AbstractPathJob.prepareStart((LivingEntity)this.ourEntity);
        this.desiredPos = new BlockPos(newX, newY, newZ);
        return this.setPathJob(new PathJobMoveToLocation(CompatibilityUtils.getWorldFromEntity((Entity)this.ourEntity), start, this.desiredPos, (int)this.ourEntity.func_110148_a(Attributes.field_233819_b_).func_111126_e(), (LivingEntity)this.ourEntity), this.desiredPos, speedFactor, true);
    }

    @Override
    public boolean tryMoveToBlockPos(BlockPos pos, double speedFactor) {
        this.moveToXYZ(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), speedFactor);
        return true;
    }

    protected PathFinder func_179679_a(int p_179679_1_) {
        return null;
    }

    protected boolean func_75485_k() {
        if (this.ourEntity.field_184239_as != null) {
            @NotNull PathPointExtended pEx = (PathPointExtended)this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e());
            if (pEx.isRailsExit()) {
                Entity entity = this.ourEntity.field_184239_as;
                this.ourEntity.func_184210_p();
                entity.func_70106_y();
            } else if (!pEx.isOnRails()) {
                if (this.ourEntity.field_184239_as instanceof MinecoloniesMinecart) {
                    Entity entity = this.ourEntity.field_184239_as;
                    this.ourEntity.func_184210_p();
                    entity.func_70106_y();
                } else if (this.destination == null || this.field_75515_a.func_70092_e((double)this.destination.func_177958_n(), (double)this.destination.func_177956_o(), (double)this.destination.func_177952_p()) > 2.0) {
                    this.ourEntity.func_184210_p();
                }
            } else if ((Math.abs((double)pEx.field_75839_a - this.field_75515_a.func_226277_ct_()) > 7.0 || Math.abs((double)pEx.field_75838_c - this.field_75515_a.func_226281_cx_()) > 7.0) && this.ourEntity.field_184239_as != null) {
                Entity entity = this.ourEntity.field_184239_as;
                this.ourEntity.func_184210_p();
                entity.func_70106_y();
            }
        }
        return true;
    }

    @NotNull
    protected Vector3d func_75502_i() {
        return this.ourEntity.func_213303_ch();
    }

    public Path func_179680_a(BlockPos pos, int p_179680_2_) {
        return null;
    }

    protected boolean func_75493_a(Vector3d start, Vector3d end, int sizeX, int sizeY, int sizeZ) {
        return !WorkerUtil.isPathBlock(this.field_75513_b.func_180495_p(new BlockPos(start.field_72450_a, start.field_72448_b - 1.0, start.field_72449_c)).func_177230_c()) && super.func_75493_a(start, end, sizeX, sizeY, sizeZ);
    }

    public double getSpeedFactor() {
        if (this.ourEntity.func_70090_H()) {
            this.field_75511_d = this.walkSpeedFactor * this.swimSpeedFactor;
            return this.field_75511_d;
        }
        this.field_75511_d = this.walkSpeedFactor;
        return this.walkSpeedFactor;
    }

    public void func_75489_a(double speedFactor) {
        if (speedFactor > 2.0 || speedFactor < 0.1) {
            Log.getLogger().error("Tried to set a bad speed:" + speedFactor + " for entity:" + this.ourEntity, (Throwable)new Exception());
            return;
        }
        this.walkSpeedFactor = speedFactor;
    }

    public boolean func_75492_a(double x, double y, double z, double speedFactor) {
        if (x == 0.0 && y == 0.0 && z == 0.0) {
            return false;
        }
        this.moveToXYZ(x, y, z, speedFactor);
        return true;
    }

    public boolean func_75497_a(Entity entityIn, double speedFactor) {
        return this.tryMoveToBlockPos(entityIn.func_233580_cy_(), speedFactor);
    }

    protected void func_75487_m() {
    }

    public boolean func_75484_a(@Nullable Path path, double speedFactor) {
        if (path == null) {
            this.func_75499_g();
            return false;
        }
        this.pathStartTime = this.field_75513_b.func_82737_E();
        return super.func_75484_a(this.convertPath(path), speedFactor);
    }

    private Path convertPath(Path path) {
        int pathLength = path.func_75874_d();
        Path tempPath = null;
        if (pathLength > 0 && !(path.func_75877_a(0) instanceof PathPointExtended)) {
            @NotNull PathPointExtended[] newPoints = new PathPointExtended[pathLength];
            for (int i = 0; i < pathLength; ++i) {
                PathPoint point = path.func_75877_a(i);
                newPoints[i] = !(point instanceof PathPointExtended) ? new PathPointExtended(new BlockPos(point.field_75839_a, point.field_75837_b, point.field_75838_c)) : (PathPointExtended)point;
            }
            tempPath = new Path(Arrays.asList(newPoints), path.func_224770_k(), path.func_224771_h());
            PathPointExtended finalPoint = newPoints[pathLength - 1];
            this.destination = new BlockPos(finalPoint.field_75839_a, finalPoint.field_75837_b, finalPoint.field_75838_c);
        }
        return tempPath == null ? path : tempPath;
    }

    private boolean processCompletedCalculationResult() {
        this.pathResult.getJob().synchToClient((LivingEntity)this.field_75515_a);
        this.func_75484_a(this.pathResult.getPath(), this.getSpeedFactor());
        if (this.pathResult != null) {
            this.pathResult.setStatus(PathFindingStatus.IN_PROGRESS_FOLLOWING);
        }
        return false;
    }

    private boolean handleLadders(int oldIndex) {
        if (!this.func_75500_f()) {
            @NotNull PathPointExtended pEx = (PathPointExtended)this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e());
            PathPointExtended pExNext = this.func_75505_d().func_75874_d() > this.func_75505_d().func_75873_e() + 1 ? (PathPointExtended)this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e() + 1) : null;
            BlockPos pos = new BlockPos(pEx.field_75839_a, pEx.field_75837_b, pEx.field_75838_c);
            if (pEx.isOnLadder() && pExNext != null && (pEx.field_75837_b != pExNext.field_75837_b || this.field_75515_a.func_226278_cu_() > (double)pEx.field_75837_b) && this.field_75513_b.func_180495_p(pos).isLadder((IWorldReader)this.field_75513_b, pos, (LivingEntity)this.ourEntity)) {
                return this.handlePathPointOnLadder(pEx);
            }
            if (this.ourEntity.func_70090_H()) {
                return this.handleEntityInWater(oldIndex, pEx);
            }
            if (this.field_75513_b.field_73012_v.nextInt(10) == 0) {
                this.field_75511_d = !pEx.isOnLadder() && pExNext != null && pExNext.isOnLadder() ? this.getSpeedFactor() / 4.0 : (WorkerUtil.isPathBlock(this.field_75513_b.func_180495_p(this.findBlockUnderEntity((Entity)this.ourEntity)).func_177230_c()) ? 1.3 * this.getSpeedFactor() : this.getSpeedFactor());
            }
        }
        return false;
    }

    private BlockPos findBlockUnderEntity(@NotNull Entity parEntity) {
        int blockX = (int)Math.round(parEntity.func_226277_ct_());
        int blockY = MathHelper.func_76128_c((double)(parEntity.func_226278_cu_() - 0.2));
        int blockZ = (int)Math.round(parEntity.func_226281_cx_());
        return new BlockPos(blockX, blockY, blockZ);
    }

    private boolean handleRails() {
        if (!this.func_75500_f()) {
            PathPointExtended pExNext;
            @NotNull PathPointExtended pEx = (PathPointExtended)this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e());
            PathPointExtended pathPointExtended = pExNext = this.func_75505_d().func_75874_d() > this.func_75505_d().func_75873_e() + 1 ? (PathPointExtended)this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e() + 1) : null;
            if (pExNext != null && pEx.field_75839_a == pExNext.field_75839_a && pEx.field_75838_c == pExNext.field_75838_c) {
                PathPointExtended pathPointExtended2 = pExNext = this.func_75505_d().func_75874_d() > this.func_75505_d().func_75873_e() + 2 ? (PathPointExtended)this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e() + 2) : null;
            }
            if (pEx.isOnRails() || pEx.isRailsExit()) {
                return this.handlePathOnRails(pEx, pExNext);
            }
        }
        return false;
    }

    private boolean handlePathOnRails(PathPointExtended pEx, PathPointExtended pExNext) {
        BlockPos blockPos;
        if (pEx.isRailsEntry()) {
            blockPos = new BlockPos(pEx.field_75839_a, pEx.field_75837_b, pEx.field_75838_c);
            if (!this.spawnedPos.equals((Object)blockPos)) {
                BlockState blockstate = this.field_75513_b.func_180495_p(blockPos);
                RailShape railshape = blockstate.func_177230_c() instanceof AbstractRailBlock ? ((AbstractRailBlock)blockstate.func_177230_c()).getRailDirection(blockstate, (IBlockReader)this.field_75513_b, blockPos, null) : RailShape.NORTH_SOUTH;
                double yOffset = 0.0;
                if (railshape.func_208092_c()) {
                    yOffset = 0.5;
                }
                if (this.field_75515_a.field_184239_as instanceof MinecoloniesMinecart) {
                    ((MinecoloniesMinecart)this.field_75515_a.field_184239_as).func_70494_i(1);
                } else {
                    MinecoloniesMinecart minecart = (MinecoloniesMinecart)ModEntities.MINECART.func_200721_a(this.field_75513_b);
                    double x = (double)pEx.field_75839_a + 0.5;
                    double y = (double)pEx.field_75837_b + 0.625 + yOffset;
                    double z = (double)pEx.field_75838_c + 0.5;
                    minecart.func_70107_b(x, y, z);
                    minecart.func_213317_d(Vector3d.field_186680_a);
                    minecart.field_70169_q = x;
                    minecart.field_70167_r = y;
                    minecart.field_70166_s = z;
                    this.field_75513_b.func_217376_c((Entity)minecart);
                    minecart.func_70494_i(1);
                    this.field_75515_a.func_184205_a((Entity)minecart, true);
                }
                this.spawnedPos = blockPos;
            }
        } else {
            this.spawnedPos = BlockPos.field_177992_a;
        }
        if (this.field_75515_a.field_184239_as instanceof MinecoloniesMinecart && pExNext != null) {
            blockPos = new BlockPos(pEx.field_75839_a, pEx.field_75837_b, pEx.field_75838_c);
            BlockPos blockPosNext = new BlockPos(pExNext.field_75839_a, pExNext.field_75837_b, pExNext.field_75838_c);
            Vector3d motion = this.field_75515_a.field_184239_as.func_213322_ci();
            switch (BlockPosUtil.getXZFacing(blockPos, blockPosNext).func_176734_d()) {
                case EAST: {
                    double forward = Math.min(Math.max(motion.func_82615_a() - 0.01, -1.0), 0.0);
                    this.field_75515_a.field_184239_as.func_213317_d(motion.func_72441_c(forward == -1.0 ? -1.0 : -0.01, 0.0, 0.0));
                    break;
                }
                case WEST: {
                    double forward = Math.max(Math.min(motion.func_82615_a() + 0.01, 1.0), 0.0);
                    this.field_75515_a.field_184239_as.func_213317_d(motion.func_72441_c(forward == 1.0 ? 1.0 : 0.01, 0.0, 0.0));
                    break;
                }
                case NORTH: {
                    double forward = Math.max(Math.min(motion.func_82616_c() + 0.01, 1.0), 0.0);
                    this.field_75515_a.field_184239_as.func_213317_d(motion.func_72441_c(0.0, 0.0, forward == 1.0 ? 1.0 : 0.01));
                    break;
                }
                case SOUTH: {
                    double forward = Math.min(Math.max(motion.func_82616_c() - 0.01, -1.0), 0.0);
                    this.field_75515_a.field_184239_as.func_213317_d(motion.func_72441_c(0.0, 0.0, forward == -1.0 ? -1.0 : -0.01));
                    break;
                }
            }
        }
        return false;
    }

    private boolean handlePathPointOnLadder(PathPointExtended pEx) {
        Vector3d vec3 = this.func_75505_d().func_75878_a((Entity)this.ourEntity);
        BlockPos entityPos = new BlockPos(this.ourEntity.func_213303_ch());
        if (vec3.func_186679_c(this.ourEntity.func_226277_ct_(), vec3.field_72448_b, this.ourEntity.func_226281_cx_()) < 0.6 && Math.abs(vec3.field_72448_b - (double)entityPos.func_177956_o()) <= 2.0) {
            double newSpeed = 0.3;
            switch (pEx.getLadderFacing()) {
                case NORTH: {
                    vec3 = vec3.func_72441_c(0.0, 0.0, 0.4);
                    break;
                }
                case SOUTH: {
                    vec3 = vec3.func_72441_c(0.0, 0.0, -0.4);
                    break;
                }
                case WEST: {
                    vec3 = vec3.func_72441_c(0.4, 0.0, 0.0);
                    break;
                }
                case EAST: {
                    vec3 = vec3.func_72441_c(-0.4, 0.0, 0.0);
                    break;
                }
                case UP: {
                    vec3 = vec3.func_72441_c(0.0, 1.0, 0.0);
                    break;
                }
                default: {
                    newSpeed = 0.0;
                    this.field_75515_a.func_226284_e_(true);
                    this.isSneaking = true;
                    this.ourEntity.func_70605_aq().func_75642_a(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, 0.2);
                }
            }
            if (newSpeed > 0.0) {
                if (!(this.field_75513_b.func_180495_p(this.ourEntity.func_233580_cy_()).func_177230_c() instanceof LadderBlock)) {
                    this.ourEntity.func_213317_d(this.ourEntity.func_213322_ci().func_72441_c(0.0, 0.1, 0.0));
                }
                this.ourEntity.func_70605_aq().func_75642_a(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, newSpeed);
            } else {
                if (!this.field_75513_b.func_180495_p(entityPos.func_177977_b()).isLadder((IWorldReader)this.field_75513_b, entityPos.func_177977_b(), (LivingEntity)this.ourEntity)) {
                    return false;
                }
                this.ourEntity.func_70657_f(-0.5f);
                return true;
            }
        }
        return false;
    }

    private boolean handleEntityInWater(int oldIndex, PathPointExtended pEx) {
        int curIndex = this.func_75505_d().func_75873_e();
        if (curIndex > 0 && curIndex + 1 < this.func_75505_d().func_75874_d() && this.func_75505_d().func_75877_a((int)(curIndex - 1)).field_75837_b != pEx.field_75837_b) {
            oldIndex = curIndex + 1;
        }
        this.func_75505_d().func_75872_c(oldIndex);
        Vector3d Vector3d2 = this.func_75505_d().func_75878_a((Entity)this.ourEntity);
        Vector3d vector3d = new Vector3d(this.ourEntity.func_226277_ct_(), Vector3d2.field_72448_b, this.ourEntity.func_226281_cx_());
        if (Vector3d2.func_72436_e(vector3d) < 0.1 && Math.abs(this.ourEntity.func_226278_cu_() - Vector3d2.field_72448_b) < 0.5) {
            this.func_75505_d().func_75875_a();
            if (this.func_75500_f()) {
                return true;
            }
            Vector3d2 = this.func_75505_d().func_75878_a((Entity)this.ourEntity);
        }
        this.ourEntity.func_70605_aq().func_75642_a(Vector3d2.field_72450_a, Vector3d2.field_72448_b, Vector3d2.field_72449_c, this.getSpeedFactor());
        return false;
    }

    protected void func_75508_h() {
        Vector3d next;
        this.getSpeedFactor();
        int curNode = this.field_75514_c.func_75873_e();
        int curNodeNext = curNode + 1;
        if (curNodeNext < this.field_75514_c.func_75874_d()) {
            if (!(this.field_75514_c.func_75877_a(curNode) instanceof PathPointExtended)) {
                this.field_75514_c = this.convertPath(this.field_75514_c);
            }
            PathPointExtended pEx = (PathPointExtended)this.field_75514_c.func_75877_a(curNode);
            PathPointExtended pExNext = (PathPointExtended)this.field_75514_c.func_75877_a(curNodeNext);
            if (pEx.isOnLadder() && pEx.getLadderFacing() == Direction.DOWN && !pExNext.isOnLadder()) {
                Vector3d vec3 = this.func_75502_i();
                if (vec3.field_72448_b - (double)pEx.field_75837_b < 0.001) {
                    this.field_75514_c.func_75872_c(curNodeNext);
                }
                return;
            }
        }
        this.field_188561_o = 0.5f;
        boolean wentAhead = false;
        boolean isTracking = AbstractPathJob.trackingMap.containsValue(this.ourEntity.func_110124_au());
        HashSet<BlockPos> reached = new HashSet<BlockPos>();
        for (int i = this.field_75514_c.func_75873_e(); i < Math.min(this.field_75514_c.func_75874_d(), this.field_75514_c.func_75873_e() + 4); ++i) {
            next = this.field_75514_c.func_75881_a((Entity)this.field_75515_a, i);
            if (!(Math.abs(this.field_75515_a.func_226277_ct_() - next.field_72450_a) < (double)this.field_188561_o - Math.abs(this.field_75515_a.func_226278_cu_() - next.field_72448_b) * 0.1) || !(Math.abs(this.field_75515_a.func_226281_cx_() - next.field_72449_c) < (double)this.field_188561_o - Math.abs(this.field_75515_a.func_226278_cu_() - next.field_72448_b) * 0.1) || !(Math.abs(this.field_75515_a.func_226278_cu_() - next.field_72448_b) <= 1.0)) continue;
            this.field_75514_c.func_75875_a();
            wentAhead = true;
            if (!isTracking) continue;
            PathPoint point = this.field_75514_c.func_75877_a(i);
            reached.add(new BlockPos(point.field_75839_a, point.field_75837_b, point.field_75838_c));
        }
        if (isTracking) {
            AbstractPathJob.synchToClient(reached, this.ourEntity);
            reached.clear();
        }
        if (this.field_75514_c.func_75879_b()) {
            this.onPathFinish();
            return;
        }
        if (wentAhead) {
            return;
        }
        if (curNode >= this.field_75514_c.func_75874_d() || curNode <= 1) {
            return;
        }
        Vector3d curr = this.field_75514_c.func_75881_a((Entity)this.field_75515_a, curNode - 1);
        next = this.field_75514_c.func_75881_a((Entity)this.field_75515_a, curNode);
        if (this.field_75515_a.func_213303_ch().func_72438_d(curr) >= 2.0 && this.field_75515_a.func_213303_ch().func_72438_d(next) >= 2.0) {
            for (int currentIndex = curNode - 1; currentIndex > 0; --currentIndex) {
                Vector3d tempoPos = this.field_75514_c.func_75881_a((Entity)this.field_75515_a, currentIndex);
                if (this.field_75515_a.func_213303_ch().func_72438_d(tempoPos) <= 1.0) {
                    this.field_75514_c.func_75872_c(currentIndex);
                    continue;
                }
                if (!isTracking) continue;
                reached.add(new BlockPos(tempoPos.field_72450_a, tempoPos.field_72448_b, tempoPos.field_72449_c));
            }
        }
        if (isTracking) {
            AbstractPathJob.synchToClient(reached, this.ourEntity);
            reached.clear();
        }
    }

    private void onPathFinish() {
        this.func_75499_g();
    }

    public void func_188554_j() {
    }

    protected void func_179677_a(@NotNull Vector3d positionVec3) {
    }

    public void func_75499_g() {
        if (this.pathResult != null) {
            this.pathResult.cancel();
            this.pathResult.setStatus(PathFindingStatus.CANCELLED);
            this.pathResult = null;
        }
        this.destination = null;
        super.func_75499_g();
    }

    @Override
    @Nullable
    public WaterPathResult moveToWater(int range, double speed, List<Tuple<BlockPos, BlockPos>> ponds) {
        @NotNull BlockPos start = AbstractPathJob.prepareStart((LivingEntity)this.ourEntity);
        return (WaterPathResult)this.setPathJob(new PathJobFindWater(CompatibilityUtils.getWorldFromEntity((Entity)this.ourEntity), start, ((AbstractEntityCitizen)this.ourEntity).getCitizenColonyHandler().getWorkBuilding().getPosition(), range, ponds, (LivingEntity)this.ourEntity), null, speed, true);
    }

    @Override
    public TreePathResult moveToTree(BlockPos startRestriction, BlockPos endRestriction, double speed, List<ItemStorage> excludedTrees, int dyntreesize, IColony colony) {
        @NotNull BlockPos start = AbstractPathJob.prepareStart((LivingEntity)this.ourEntity);
        BlockPos buildingPos = ((AbstractEntityCitizen)this.field_75515_a).getCitizenColonyHandler().getWorkBuilding().getPosition();
        BlockPos furthestRestriction = BlockPosUtil.getFurthestCorner(start, startRestriction, endRestriction);
        PathJobFindTree job = new PathJobFindTree(CompatibilityUtils.getWorldFromEntity((Entity)this.field_75515_a), start, buildingPos, startRestriction, endRestriction, furthestRestriction, excludedTrees, dyntreesize, colony, (LivingEntity)this.ourEntity);
        return (TreePathResult)this.setPathJob(job, null, speed, true);
    }

    @Override
    public TreePathResult moveToTree(int range, double speed, List<ItemStorage> excludedTrees, int dyntreesize, IColony colony) {
        @NotNull BlockPos start = AbstractPathJob.prepareStart((LivingEntity)this.ourEntity);
        BlockPos buildingPos = ((AbstractEntityCitizen)this.field_75515_a).getCitizenColonyHandler().getWorkBuilding().getPosition();
        if (BlockPosUtil.getDistance2D(buildingPos, ((AbstractEntityCitizen)this.field_75515_a).func_233580_cy_()) > (long)(range * 4)) {
            start = buildingPos;
        }
        return (TreePathResult)this.setPathJob(new PathJobFindTree(CompatibilityUtils.getWorldFromEntity((Entity)this.field_75515_a), start, buildingPos, range, excludedTrees, dyntreesize, colony, (LivingEntity)this.ourEntity), null, speed, true);
    }

    @Override
    @Nullable
    public PathResult moveToLivingEntity(@NotNull Entity e, double speed) {
        return this.moveToXYZ(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_(), speed);
    }

    @Override
    @Nullable
    public PathResult moveAwayFromLivingEntity(@NotNull Entity e, double distance, double speed) {
        return this.moveAwayFromXYZ(new BlockPos(e.func_213303_ch()), distance, speed, true);
    }

    public void func_212239_d(boolean canSwim) {
        super.func_212239_d(canSwim);
        this.getPathingOptions().setCanSwim(canSwim);
    }

    @Override
    public BlockPos getDesiredPos() {
        return this.desiredPos;
    }

    @Override
    public void setStuckHandler(IStuckHandler stuckHandler) {
        this.stuckHandler = stuckHandler;
    }

    @Override
    public void setSwimSpeedFactor(double factor) {
        this.swimSpeedFactor = factor;
    }
}

